/*
 * Decompiled with CFR 0.152.
 */
package com.android.payment.domain.use_case;

import com.android.payment.domain.model.ACheckDto;
import com.android.payment.domain.use_case.QuerySettlementCheques;
import com.utility.CollectionBinder;
import com.utility.DbConnection;
import com.utility.TncJdbc;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class QuerySettlementCheques {
    private final DbConnection dbConnection;

    public List<ACheckDto> invoke(List<String> settlementIdList) {
        String dropSql = "IF (OBJECT_ID('tempdb..#SettlementChecks') IS NOT NULL) \n DROP TABLE #SettlementChecks \n";
        String sql = "IF (OBJECT_ID('tempdb..#SettlementChecks') IS NOT NULL) \n DROP TABLE #SettlementChecks \nSELECT * INTO #SettlementChecks FROM ( \n SELECT cp.check_code AS serverId, s.Sanad_Code as settlementId, \n  cp.Check_Number as [number], d.Bank_Code as bankCode, \n  cp.Export_Date as issueDate, cp.Receive_Date as dueDate, \n  cp.Branch AS branchName, cp.BranchCode as branchCode, \n  cp.Account_Number as accountNo, IsNull(cp.Cust,0) as amount, \n  cp.comm as [description], cp.Export_Date as actionDate, \n  IsNull(cp.Sayad_Number, '') sayadId, \n  cp.IsSayad, null as FactureId \n  FROM [Check] cp WITH(NOLOCK) \n  INNER JOIN Sanad s ON s.Sanad_Code = cp.Sanad_Code \n  INNER JOIN CUSTOMER p WITH(NOLOCK) ON p.C_Code = cp.C_Code_source \n  INNER Join USERDB us  WITH(NOLOCK) ON s.UserCodeInc = us.UserCodeInc \n  INNER JOIN NewBank d  WITH(NOLOCK) ON cp.Bank_Code = d.Bank_Code \n  WHERE 1=1 \n UNION ALL \n SELECT cp.id AS serverId, s.id as settlementId, cp.Check_Number as [number], \n  d.Bank_Code as bankCode, cp.Export_Date as issueDate, \n  cp.Receive_Date as dueDate, cp.Branch AS branchName, \n  cp.BranchCode as branchCode, cp.Account_Number as accountNo, \n  IsNull(cp.Cust,0) as amount, cp.C_Comment as [description], \n  cp.Export_Date as actionDate, IsNull(cp.Sayad_Number, '') sayadId, cp.IsSayad, cp.factureId \n  FROM TmpCheck cp WITH(NOLOCK) \n  INNER JOIN TmpSanad s WITH(NOLOCK) ON s.id = cp.IDSanad \n  INNER JOIN CUSTOMER p WITH(NOLOCK) On p.C_Code = s.C_Code \n  INNER JOIN USERDB us  WITH(NOLOCK) On s.UserCode = us.UserCodeInc \n  INNER JOIN NEWBANK d  WITH(NOLOCK) On cp.Bank_Code = d.Bank_Code \n  Where IdSanad in (Select Id from TmpSanad Where IsNull(Sanad_code, '') = '')  \n) AS SettlementChecks \n WHERE settlementId IN (" + CollectionBinder.builder().build().wrapThenBind(settlementIdList) + ") \n SELECT * FROM #SettlementChecks";
        TncJdbc jdbc = this.dbConnection.getJdbcTemplate();
        List result = jdbc.query(sql, (RowMapper)new ChequeMapper());
        jdbc.execute("IF (OBJECT_ID('tempdb..#SettlementChecks') IS NOT NULL) \n DROP TABLE #SettlementChecks \n");
        return result;
    }

    public QuerySettlementCheques(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }
}

